<?php
if( ! defined( 'ABSPATH' ) ){
	exit; // Exit if accessed directly
}
?>

<div id="mfn-dashboard" class="wrap about-wrap">

	<?php include_once get_theme_file_path('/functions/admin/templates/parts/header.php'); ?>

	<div class="dashboard-tab register">

		<div class="col col-left">

			<?php if( mfn_is_registered() ): ?>

				<h3 class="primary"><?php esc_html_e( 'قالب قبلا فعال شده است ', 'mfn-opts' ); ?></h3>

				<form class="form-register form-deregister" method="post">

					<?php settings_fields( 'betheme_registration' ); ?>

					<p>
						<code><?php echo esc_html( mfn_get_purchase_code_hidden() ); ?></code>
					</p>

					<?php if( mfn_is_hosted() ): ?>

						<p class="confirm deregister" style="margin-bottom:40px">
							You are using Envato Hosted, this subscription code can not be deregistered.
						</p>

					<?php else: ?>

						<p class="confirm deregister">
							<a class="mfn-button mfn-button-primary mfn-button-fw"><?php esc_html_e( 'Deregister Theme', 'mfn-opts' ); ?></a>
						</p>

					<?php endif; ?>

					<?php if( WHITE_LABEL ): ?>

						<p class="question"><?php _e( 'This feature is disabled in White Label mode.', 'mfn-opts' );?></p>

					<?php else: ?>

						<p class="question">
							<span><?php esc_html_e( 'این کار باعث خواهد شد قالب شما قفل شود . ادامه میدهید ؟ ', 'mfn-opts' ); ?></span>
							<a class="mfn-button cancel" target="_blank" href="#"><?php esc_html_e( 'Cancel', 'mfn-opts' ); ?></a>
							<input type="submit" class="mfn-button mfn-button-primary" name="deregister" value="<?php esc_attr_e( 'Deregister', 'mfn-opts' ); ?>" />
						</p>

					<?php endif; ?>

				</form>
				<?php if( ! WHITE_LABEL ): ?>

					<h3><?php esc_html_e( 'لایسنس اختصاصی', 'mfn-opts' ); ?></h3>	

					<?php
						$purchase_link = 'https://www.zhaket.com/web/betheme-responsive-multi-purpose/';

						if( mfn_is_hosted() ){
							$purchase_link = 'https://www.zhaket.com/web/betheme-responsive-multi-purpose/';
						}
					?>

					
                    <a class="mfn-button mfn-button-secondary" target="_blank" href="<?php echo $purchase_link; ?>"><?php esc_html_e( 'پشتیبانی در ژاکت', 'mfn-opts' ); ?></a>

                    <p><span class="status yes dashicons dashicons-yes"></span><strong>چگونه بسته جدید محصول را دانلود کنیم ؟</strong></p>

					<ol>
						<li>وارد سایت ژاکت شده و به قسمت <a target="_blank" href="https://zhaket.com/dashboard/downloads/">دانلود ها </a> مراجعه فرمائید</li>
						<li>روی  <strong> نام محصول </strong>کلیک کنید</li>
						<li>سپس <strong>روی دانلود فایل محصول </strong>کلیک کرده و محصول با نسخه جدید را دانلود فرمائید</li>
                        					</ol>
                    <p><span class="status yes dashicons dashicons-yes"></span><strong>چگونه نسخه جدید را خودکار بروزرسانی کنیم ؟</strong></p>
					<ol>
						<li>وارد سایت ژاکت شده و<strong> افزونه  به روز رسان هوشمند ژاکِت </strong>را دانلود و نصب نمائید</li>
						<li><a class="mfn-button mfn-button-secondary" target="_blank" href="https://landing.zhaket.com/festival/zhaket-smart-updater/"><?php esc_html_e( 'افزونه  به روز رسان هوشمند ژاکِت ', 'mfn-opts' ); ?></a></li>
						<li>سپس <strong>بعد از دریافت ایمیل اطلاع رسانی نسخه جدید محصول از ژاکت </strong>وارد پیشخوان سایت شده و بروزرسانی خودکار برای قالب را دریافت نمائید</li>
                        					</ol>
				<?php endif; ?>

			<?php else: ?>

				<h3 class="primary">فعال سازی امکانات قالب</h3>

				<?php if( is_super_admin() ): ?>

					<form class="form-register" method="post">

						<?php settings_fields( 'betheme_registration' ); ?>

						<p>
					<a class="mfn-button mfn-button-secondary" target="_blank" href="https://www.zhaket.com/web/betheme-responsive-multi-purpose/">خریداری قالب و دریافت لایسنس جدید</a>
						</p>

					</form>

					<p><strong>چگونه یک لایسنس معتبر برای قالب بی تهیه کنیم ؟</strong></p>

					<ol>
						<li>وارد سایت ژاکت شده و به قسمت <a target="_blank" href="https://zhaket.com/dashboard/downloads/">دانلود ها </a> مراجعه فرمائید</li>
						<li>روی  <strong> نام محصول </strong>کلیک کنید</li>
						<li>سپس <strong>لایسنس اختصاصی خود را </strong>برای دامنه ای که معرفی کردید کپی نمائید</li>
						<li>در آخر <strong>در بخش ثبت قالب بی </strong>در پیشخوان سایت فعلی منوی ثبت قالب بی  ( زیر منوی تنظیمات اصلی وردپرس ) وارد نمائید</li>
					</ol>

					<h3>خرید قالب</h3>

					<p>اگر شما قالب را خریداری نکرده اید احتمال مسدود سازی آن وجود دارد </p>

					<a class="mfn-button mfn-button-secondary" target="_blank" href="https://www.zhaket.com/web/betheme-responsive-multi-purpose/">خریداری قالب و دریافت لایسنس جدید</a>

				<?php else: ?>

					<p>لطفا با سطح دسترسی مدیریت وارد شه و قالب را ثبت نمائید</p>

				<?php endif; ?>

			<?php endif; ?>

			<?php if( ! mfn_is_hosted() ): ?>

				

			<?php endif; ?>

		</div>

		<div class="col col-right">

			<?php if( ! mfn_is_hosted() ): ?>

				<h3><?php esc_html_e( 'System Status', 'mfn-opts' ); ?></h3>

				<?php include_once get_theme_file_path('/functions/admin/templates/parts/mini-status.php'); ?>

			<?php endif; ?>

			<h3>دسترسی سریع </h3>

			<ul class="links">

				<li><a href="admin.php?page=be-plugins"><?php esc_html_e( 'Install Plugins', 'mfn-opts' ); ?></a></li>
				<li><a href="admin.php?page=be-websites"><?php esc_html_e( 'Pre-built websites', 'mfn-opts' ); ?></a></li>
				<li><a href="admin.php?page=be-options"><?php esc_html_e( 'Theme Options', 'mfn-opts' ); ?></a></li>

			</ul>

		</div>

	</div>

</div>
